/*
 * Decompiled with CFR 0.152.
 */
package sufftracker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sufftracker.SettingsHolder;

public class WebSync {
    private static WebSync instance;

    private WebSync() {
    }

    public static WebSync instance() {
        if (instance == null) {
            instance = new WebSync();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long latestTimestamp() {
        try {
            BufferedReader rd;
            String post = URLEncoder.encode("session", "UTF-8") + "=" + URLEncoder.encode(SettingsHolder.instance().getString("session"), "UTF-8");
            URL url = new URL("http://lrinke.de/sufftrack/get.php");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
                wr.write(post);
                wr.flush();
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = rd.readLine();
                if (line != null) {
                    long l = Long.valueOf(line);
                    return l;
                }
            }
            rd.close();
            return -1L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    public void push(String sendData) {
        System.out.println("push line to server");
        try {
            BufferedReader rd;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(sendData.getBytes());
            byte[] result = md5.digest();
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < result.length; ++i) {
                if (result[i] <= 15 && result[i] >= 0) {
                    hexString.append("0");
                }
                hexString.append(Integer.toHexString(0xFF & result[i]));
            }
            String post = URLEncoder.encode("data", "UTF-8") + "=" + URLEncoder.encode(sendData, "UTF-8");
            post = post + "&" + URLEncoder.encode("check", "UTF-8") + "=" + URLEncoder.encode(hexString.toString(), "UTF-8");
            post = post + "&" + URLEncoder.encode("session", "UTF-8") + "=" + URLEncoder.encode(SettingsHolder.instance().getString("session"), "UTF-8");
            URL url = new URL("http://lrinke.de/sufftrack/put.php");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
                String line;
                wr.write(post);
                wr.flush();
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    System.out.println(line);
                }
            }
            rd.close();
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            Logger.getLogger(WebSync.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

